dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 235, 400, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 3, 305, 250, "assets/images/table/redtable", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 250;


-- Group 1
guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 2, 3000);


-- Group 2

guest = LManager.GenGuest(female03);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(3, 4, 20000);


-- Group 2

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table1;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 6, 36000);

-- Group 3


guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 9, 72000);


-- Group 4

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 11, 100000);

-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 12, 120000);



LManager:AdjustGuestTolerance(150);

LManager:SetLevelSetting ("bridesmaidsDelay", 60000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Custom event - effects path, x, y, delay
LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 97000 );

-- Set up the Level Settings
LManager:SetLevelNumber(1,7);
LManager:SetLevelScores(3800, 5300);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Uptempo 1.ogg", "assets/audio/music/Disco Dance 1.ogg");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );